/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import hex.tree.DTreeScorer;
import hex.tree.SharedTree;
import java.util.Arrays;
import java.util.Random;
import water.Key;
import water.fvec.C0DChunk;
import water.fvec.Chunk;

public class ReconstructTreeState
extends DTreeScorer<ReconstructTreeState> {
    protected final double _rate;
    protected final boolean _OOBEnabled;

    public ReconstructTreeState(int ncols, int nclass, SharedTree st, double rate, Key[][] treeKeys, boolean oob) {
        super(ncols, nclass, st, treeKeys);
        this._rate = rate;
        this._OOBEnabled = oob;
    }

    public void map(Chunk[] chks) {
        double[] data = new double[this._ncols];
        double[] preds = new double[this._nclass + 1];
        int ntrees = this._trees.length;
        C0DChunk weight = this._st.hasWeightCol() ? this._st.chk_weight(chks) : new C0DChunk(1.0, chks[0]._len);
        Chunk oobt = this._st.chk_oobt(chks);
        Chunk resp = this._st.chk_resp(chks);
        for (int tidx = 0; tidx < ntrees; ++tidx) {
            Random rng = this.rngForTree(this._trees[tidx], oobt.cidx());
            for (int row = 0; row < oobt._len; ++row) {
                boolean rowIsOOB;
                double y;
                double w = weight.atd(row);
                if (w == 0.0 || Double.isNaN(y = resp.atd(row))) continue;
                boolean bl = rowIsOOB = this._OOBEnabled && (double)rng.nextFloat() >= this._rate;
                if (this._OOBEnabled && !rowIsOOB) continue;
                for (int i = 0; i < this._ncols; ++i) {
                    data[i] = chks[i].atd(row);
                }
                Arrays.fill(preds, 0.0);
                this.score0(data, preds, this._trees[tidx]);
                if (this._nclass == 1) {
                    preds[1] = preds[0];
                }
                for (int c = 0; c < this._nclass; ++c) {
                    double prediction = preds[1 + c];
                    if (preds[1 + c] == 0.0) continue;
                    Chunk ctree = this._st.chk_tree(chks, c);
                    double wcount = oobt.atd(row);
                    if (this._OOBEnabled && this._nclass >= 2) {
                        ctree.set(row, (double)((float)(ctree.atd(row) * wcount + prediction)) / (wcount + w));
                        continue;
                    }
                    ctree.set(row, (float)(ctree.atd(row) + prediction));
                }
                if (!rowIsOOB) continue;
                oobt.set(row, oobt.atd(row) + w);
            }
        }
        this._st = null;
    }

    private Random rngForTree(CompressedTree[] ts, int cidx) {
        return ts[0].rngForChunk(cidx);
    }
}

