/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.pca.ModelMetricsPCA;
import hex.pca.PCA;
import water.DKV;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.codegen.CodeGenerator;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.JCodeSB;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.JCodeGen;
import water.util.SBPrintStream;
import water.util.TwoDimTable;

public class PCAModel
extends Model<PCAModel, PCAParameters, PCAOutput> {
    public PCAModel(Key selfKey, PCAParameters parms, PCAOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsPCA.PCAModelMetrics(((PCAParameters)this._parms)._k);
    }

    protected Frame predictScoreImpl(Frame orig, Frame adaptedFr, String destination_key, final Job j) {
        Frame adaptFrm = new Frame(adaptedFr);
        for (int i = 0; i < ((PCAParameters)this._parms)._k; ++i) {
            adaptFrm.add("PC" + String.valueOf(i + 1), adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                if (this.isCancelled() || j != null && j.stop_requested()) {
                    return;
                }
                double[] tmp = new double[((PCAOutput)PCAModel.this._output)._names.length];
                double[] preds = new double[((PCAParameters)PCAModel.this._parms)._k];
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = PCAModel.this.score0(chks, row, tmp, preds);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((PCAOutput)PCAModel.this._output)._names.length + c].set(row, p[c]);
                    }
                }
                if (j != null) {
                    j.update(1L);
                }
            }
        }.doAll(adaptFrm);
        int x = ((PCAOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        f = new Frame(null == destination_key ? Key.make() : Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig, null, null);
        return f;
    }

    protected double[] score0(double[] data, double[] preds) {
        int numStart = ((PCAOutput)this._output)._catOffsets[((PCAOutput)this._output)._catOffsets.length - 1];
        assert (data.length == ((PCAOutput)this._output)._nnums + ((PCAOutput)this._output)._ncats);
        for (int i = 0; i < ((PCAParameters)this._parms)._k; ++i) {
            preds[i] = 0.0;
            for (int j = 0; j < ((PCAOutput)this._output)._ncats; ++j) {
                double tmp = data[((PCAOutput)this._output)._permutation[j]];
                if (Double.isNaN(tmp)) continue;
                int last_cat = ((PCAOutput)this._output)._catOffsets[j + 1] - ((PCAOutput)this._output)._catOffsets[j] - 1;
                int level = (int)tmp - (((PCAParameters)this._parms)._use_all_factor_levels ? 0 : 1);
                if (level < 0 || level > last_cat) continue;
                int n = i;
                preds[n] = preds[n] + ((PCAOutput)this._output)._eigenvectors_raw[((PCAOutput)this._output)._catOffsets[j] + level][i];
            }
            int dcol = ((PCAOutput)this._output)._ncats;
            int vcol = numStart;
            for (int j = 0; j < ((PCAOutput)this._output)._nnums; ++j) {
                int n = i;
                preds[n] = preds[n] + (data[((PCAOutput)this._output)._permutation[dcol]] - ((PCAOutput)this._output)._normSub[j]) * ((PCAOutput)this._output)._normMul[j] * ((PCAOutput)this._output)._eigenvectors_raw[vcol][i];
                ++dcol;
                ++vcol;
            }
        }
        return preds;
    }

    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        sb = super.toJavaInit(sb, fileCtx);
        sb.ip("public boolean isSupervised() { return " + this.isSupervised() + "; }").nl();
        sb.ip("public int nfeatures() { return " + ((PCAOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((PCAParameters)this._parms)._k + "; }").nl();
        final String mname = JCodeGen.toJavaId((String)this._key.toString());
        fileCtx.add((Object)new CodeGenerator(){

            public void generate(JCodeSB out) {
                if (((PCAOutput)PCAModel.this._output)._nnums > 0) {
                    JCodeGen.toClassWithArray((JCodeSB)out, null, (String)(mname + "_NORMMUL"), (double[])((PCAOutput)PCAModel.this._output)._normMul, (String)"Standardization/Normalization scaling factor for numerical variables.");
                    JCodeGen.toClassWithArray((JCodeSB)out, null, (String)(mname + "_NORMSUB"), (double[])((PCAOutput)PCAModel.this._output)._normSub, (String)"Standardization/Normalization offset for numerical variables.");
                }
                JCodeGen.toClassWithArray((JCodeSB)out, null, (String)(mname + "_CATOFFS"), (int[])((PCAOutput)PCAModel.this._output)._catOffsets, (String)"Categorical column offsets.");
                JCodeGen.toClassWithArray((JCodeSB)out, null, (String)(mname + "_PERMUTE"), (int[])((PCAOutput)PCAModel.this._output)._permutation, (String)"Permutation index vector.");
                JCodeGen.toClassWithArray((JCodeSB)out, null, (String)(mname + "_EIGVECS"), (double[][])((PCAOutput)PCAModel.this._output)._eigenvectors_raw, (String)"Eigenvector matrix.");
            }
        });
        return sb;
    }

    protected void toJavaPredictBody(SBPrintStream bodySb, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        String mname = JCodeGen.toJavaId((String)this._key.toString());
        bodySb.i().p("java.util.Arrays.fill(preds,0);").nl();
        int cats = ((PCAOutput)this._output)._ncats;
        int nums = ((PCAOutput)this._output)._nnums;
        bodySb.i().p("final int nstart = ").pj(mname + "_CATOFFS", "VALUES").p("[").pj(mname + "_CATOFFS", "VALUES").p(".length-1];").nl();
        bodySb.i().p("for(int i = 0; i < ").p(((PCAParameters)this._parms)._k).p("; i++) {").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(cats).p("; j++) {").nl();
        bodySb.i(2).p("double d = data[").pj(mname + "_PERMUTE", "VALUES").p("[j]];").nl();
        bodySb.i(2).p("if(Double.isNaN(d)) continue;").nl();
        bodySb.i(2).p("int last = ").pj(mname + "_CATOFFS", "VALUES").p("[j+1]-").pj(mname + "_CATOFFS", "VALUES").p("[j]-1;").nl();
        bodySb.i(2).p("int c = (int)d").p(((PCAParameters)this._parms)._use_all_factor_levels ? ";" : "-1;").nl();
        bodySb.i(2).p("if(c < 0 || c > last) continue;").nl();
        bodySb.i(2).p("preds[i] += ").pj(mname + "_EIGVECS", "VALUES").p("[").pj(mname + "_CATOFFS", "VALUES").p("[j]+c][i];").nl();
        bodySb.i(1).p("}").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(nums).p("; j++) {").nl();
        bodySb.i(2).p("preds[i] += (data[").pj(mname + "_PERMUTE", "VALUES").p("[j" + (cats > 0 ? "+" + cats : "") + "]]-").pj(mname + "_NORMSUB", "VALUES").p("[j])*").pj(mname + "_NORMMUL", "VALUES").p("[j]*").pj(mname + "_EIGVECS", "VALUES").p("[j" + (cats > 0 ? "+ nstart" : "") + "][i];").nl();
        bodySb.i(1).p("}").nl();
        bodySb.i().p("}").nl();
    }

    public static class PCAOutput
    extends Model.Output {
        public double _objective;
        public double[][] _eigenvectors_raw;
        public TwoDimTable _eigenvectors;
        public double[] _std_deviation;
        public TwoDimTable _importance;
        public int _ncats;
        public int _nnums;
        public long _nobs;
        public double _total_variance;
        public int[] _catOffsets;
        public double[] _normSub;
        public double[] _normMul;
        public int[] _permutation;

        public PCAOutput(PCA b) {
            super((ModelBuilder)b);
        }

        public int nfeatures() {
            return this._names.length;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.DimReduction;
        }
    }

    public static class PCAParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public Method _pca_method = Method.GramSVD;
        public int _k = 1;
        public int _max_iterations = 1000;
        public boolean _use_all_factor_levels = false;
        public boolean _compute_metrics = true;
        public boolean _impute_missing = false;

        public String algoName() {
            return "PCA";
        }

        public String fullName() {
            return "Principal Components Analysis";
        }

        public String javaName() {
            return PCAModel.class.getName();
        }

        public long progressUnits() {
            return this._pca_method == Method.GramSVD ? 5L : 3L;
        }

        public static enum Method {
            GramSVD,
            Power,
            Randomized,
            GLRM;

        }
    }
}

