/*
 * Decompiled with CFR 0.152.
 */
package hex.api;

import hex.ModelBuilder;
import hex.aggregator.Aggregator;
import hex.api.MakeGLMModelHandler;
import hex.deeplearning.DeepLearning;
import hex.glm.GLM;
import hex.glrm.GLRM;
import hex.kmeans.KMeans;
import hex.naivebayes.NaiveBayes;
import hex.pca.PCA;
import hex.svd.SVD;
import hex.tree.drf.DRF;
import hex.tree.gbm.GBM;
import water.H2O;
import water.api.AbstractRegister;
import water.api.GridSearchHandler;
import water.api.ModelBuilderHandler;

public class RegisterAlgos
extends AbstractRegister {
    public void register(String relativeResourcePath) throws ClassNotFoundException {
        ModelBuilder[] algos;
        for (ModelBuilder algo : algos = new ModelBuilder[]{new DeepLearning(true), new GLM(true), new GLRM(true), new KMeans(true), new NaiveBayes(true), new PCA(true), new SVD(true), new DRF(true), new GBM(true), new Aggregator(true)}) {
            String base = algo.getClass().getSimpleName();
            String lbase = base.toLowerCase();
            Class<ModelBuilderHandler> bh_clz = ModelBuilderHandler.class;
            int version = 3;
            if (base.equals("SVD")) {
                version = 99;
            }
            if (base.equals("Aggregator")) {
                version = 99;
            }
            H2O.register((String)("POST /" + version + "/ModelBuilders/" + lbase), bh_clz, (String)"train", (String)("train_" + lbase), (String)("Train a " + base + " model."));
            H2O.register((String)("POST /" + version + "/ModelBuilders/" + lbase + "/parameters"), bh_clz, (String)"validate_parameters", (String)("validate_" + lbase), (String)("Validate a set of " + base + " model builder parameters."));
            H2O.register((String)("POST /99/Grid/" + lbase), GridSearchHandler.class, (String)"train", (String)("grid_search_" + lbase), (String)("Run grid search for " + base + " model."));
        }
        H2O.register((String)"POST /3/MakeGLMModel", MakeGLMModelHandler.class, (String)"make_model", (String)"make_glm_model", (String)"Make a new GLM model based on existing one");
        H2O.register((String)"GET /3/GetGLMRegPath", MakeGLMModelHandler.class, (String)"extractRegularizationPath", (String)"glm_regularization_path", (String)"Get full regularization path");
        H2O.register((String)"POST /3/DataInfoFrame", MakeGLMModelHandler.class, (String)"getDataInfoFrame", (String)"glm_datainfo_frame", (String)"Test only");
    }
}

